********************************
*Run merge code first 
************************************
*creates output for Table C1: Aggregate Household Liquidity Buffers 
**************************************
clear
clear matrix 
clear mata
set maxvar 100000


use "$path\rawdata\UnbalancedHH.dta" , clear 

/*
use "$path\rawdata\UnbalancedHH.dta" , clear 

keep if hsvalui>0 | hsvalui!=. 

collapse(mean) hsvalui, by(hhssa4 year)
gen hsvalue_sa4_mean=hsvalui 
xtile hprice_decile= hsvalui, n(10)

save "$path\rawdata\hsvalui.dta"
*/
merge m:1 hhssa4 year using "$path\rawdata\hsvalui.dta"


g bank = hwtbani
g shares = hweqini
g bonds = hwcaini
g cash = hwcaini

g liqassets = bank + shares + bonds + cash
g assets = hwassei

g dinc = hifditp -hifditn
replace dinc=0 if dinc<0

g hdebt1 = hsmgowe //approximate amount outstanding on home loans 
replace hdebt1 = 0 if hdebt1 < 0


collapse (sum) liqassets assets dinc hdebt1 hsvalui hsvalue_sa4_mean, by(year hhssa4)


gen buffer=liqassets/dinc
gen hprice_income=hsvalue_sa4_mean/dinc 
gen mort_dinc=hdebt1/dinc


gen ln_dinc=log(dinc)
gen ln_hdebt1=log(hdebt1) 

drop if buffer==0 
drop if hhssa4<0 

*Table C1: Aggregate Household Liquidity Buffers, Statistical Area Level 4 
reg buffer hprice_income
outreg2 using hprice_sa4, word dec(2) 

reg buffer hprice_income mort_dinc ln_dinc i.year i.hhssa4
outreg2 using hprice_sa4, word dec(2) append drop(i.year i.hhssa4) addnote(Estimates of dummies for year and SA4 areas are omitted ) noomitted 